
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate sample data for stock returns
data1 = [np.random.normal(0, std, 50) for std in np.random.uniform(1, 5, 5)]
data2 = [np.random.normal(0, std, 50) for std in np.random.uniform(2, 6, 5)]
data3 = [np.random.normal(0, std, 50) for std in np.random.uniform(1.5, 4.5, 5)]
labels = ["Portfolio A", "Portfolio B", "Portfolio C", "Market Index"]
vlines = [-3, 3]
xlim = [-10, 10]
ylabel = "Returns [%]"
xlabel = "Portfolio"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Boxplot
fig, ax = plt.subplots(figsize=(12, 8))  # Adjust figure size

bp1 = ax.boxplot(
    data1,
    positions=np.array(range(len(data1))) * 2.0 - 0.4,
    widths=0.3,
    patch_artist=True,
    vert=False,
    showfliers=False,
)
bp2 = ax.boxplot(
    data2,
    positions=np.array(range(len(data2))) * 2.0,
    widths=0.3,
    patch_artist=True,
    vert=False,
    showfliers=False,
)
bp3 = ax.boxplot(
    data3,
    positions=np.array(range(len(data3))) * 2.0 + 0.4,
    widths=0.3,
    patch_artist=True,
    vert=False,
    showfliers=False,
)

# New colors for the boxplots
new_colors = ["#ff9999", "#66b3ff", "#99ff99"]

# Set properties for each boxplot
for bp, color in zip([bp1, bp2, bp3], new_colors):
    for patch in bp["boxes"]:
        patch.set_facecolor(color)
    for whisker in bp["whiskers"]:
        whisker.set(color="black", linewidth=1)
    for cap in bp["caps"]:
        cap.set(color="black", linewidth=1)
    for median in bp["medians"]:
        median.set(color="black", linewidth=2)

# Add dashed line for significant thresholds adjusted for horizontal layout
ax.axvline(
    x=vlines[0], color="#d62728", linestyle="--", linewidth=1.5, label="Lower Threshold"
)
ax.axvline(
    x=vlines[1], color="#2ca02c", linestyle="--", linewidth=1.5, label="Upper Threshold"
)

# Add legend with updated colors and markers
legend_elements = [
    mpatches.Patch(color="#ff9999", label=labels[0]),
    mpatches.Patch(color="#66b3ff", label=labels[1]),
    mpatches.Patch(color="#99ff99", label=labels[2]),
    mlines.Line2D([], [], color="#d62728", linestyle="--", label="Lower Threshold"),
    mlines.Line2D([], [], color="#2ca02c", linestyle="--", label="Upper Threshold")
]

# Place legend outside the plot area
ax.legend(
    handles=legend_elements,
    loc="upper center",
    bbox_to_anchor=(0.5, -0.1),
    ncol=3,
    frameon=False,
)

# Set y-axis labels and limits
ax.set_xlim(xlim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)

# Set y-axis tick positions and labels
ax.set_yticks(range(0, len(data1) * 2, 2))
ax.set_yticklabels(["Q1", "Q2", "Q3", "Q4", "Q5"])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_100.pdf", bbox_inches="tight")
