
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Placeholder data
categories = [
    "AI high", "AI low", "AI high", "AI low",
    "VR high", "VR low", "VR high", "VR low",
    "Cloud high", "Cloud low", "Cloud high", "Cloud low",
    "Cybersec high", "Cybersec low", "Cybersec high", "Cybersec low",
    "General", "General"
]
gender = [0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1]

title = "Technology Trends Dominance"
ylabel = "Technology Type"
xlabel = "Usage Intensity Rating"

# Extract the first group of characters from each category
first_chars = [category.split(" ")[0] for category in categories]

# Find all unique first characters
unique_chars = list(set(first_chars))

# Create a margin for each unique first character
margins = {char: i for i, char in enumerate(unique_chars)}

data = [np.random.uniform(low=1, high=9, size=100) for _ in range(len(categories))]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8))
color = ["#1f77b4", "#ff7f0e"]  # Blue and orange for gender representation

# Plot each category with a margin
positions = []
for i, (category, datum, g) in enumerate(zip(categories, data, gender)):
    position = i + margins[category.split(" ")[0]]
    if position in positions:
        position = position + 4
    positions.append(position)
    bp = ax.boxplot(
        datum, positions=[position], vert=False, patch_artist=True, widths=0.6
    )
    for patch in bp["boxes"]:
        patch.set_facecolor(color[g])

ax.set_title(title)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)

plt.yticks(positions, labels=categories)

# Adding a vertical line for reference
ax.axvline(x=5, color="gray", linestyle="--", linewidth=1.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_27.pdf", bbox_inches="tight")
