
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for environmental science domain
aqi_data = [np.random.normal(50, 10, 100), np.random.normal(55, 12, 100)]
pm25_data = [np.random.normal(12, 3, 100), np.random.normal(14, 3, 100)]

# Titles and Labels
title_1 = "Air Quality Index (AQI)"
title_2 = "Particulate Matter (PM2.5)"
xticklabels = ["Station A", "Station B"]
xlabel = "Monitoring Stations"
ylabel_aqi = "AQI Value"
ylabel_pm25 = "PM2.5 Concentration (\u03BCg/m\u00B3)"
legendlabels = ["Station A", "Station B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size for better readability
plt.figure(figsize=(10, 8))

# Create subplots
fig, axs = plt.subplots(2, 2)

# Plot the boxplots
bp1 = axs[0, 0].boxplot(
    aqi_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="black"),
)
bp2 = axs[0, 1].boxplot(
    pm25_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="black"),
)
bp3 = axs[1, 0].boxplot(
    aqi_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="black"),
)
bp4 = axs[1, 1].boxplot(
    pm25_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="black"),
)

# New color scheme
colors = ["#3cb371", "#4682b4"]

# Set the colors of the boxes
for bp in [bp1, bp2, bp3, bp4]:
    for i in range(2):
        bp["boxes"][i].set_facecolor(colors[i])

# Set titles and labels
axs[0, 0].set_title(title_1)
axs[0, 1].set_title(title_2)
axs[1, 0].set_title(title_1)
axs[1, 1].set_title(title_2)

# Set x-axis labels
for ax in axs.flat:
    ax.set_xticklabels(xticklabels)
    ax.grid(True)

# Set y-axis labels for clarity
axs[0, 0].set_ylabel(ylabel_aqi)
axs[0, 1].set_ylabel(ylabel_pm25)
axs[1, 0].set_ylabel(ylabel_aqi)
axs[1, 1].set_ylabel(ylabel_pm25)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_31.pdf", bbox_inches="tight")
