
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Random data to simulate the boxplot values for a legal domain
data_Client_Wins = np.random.normal(75, 10, 100)
data_Case_Reliability = np.random.normal(85, 5, 100)
data_Efficiency = np.random.normal(65, 10, 100)
data_Client_Satisfaction = np.random.normal(80, 7, 100)

data = [data_Client_Wins, data_Case_Reliability, data_Efficiency, data_Client_Satisfaction]

# Labels and Plot Types
legend_labels = ["Client Wins", "Case Reliability", "Efficiency", "Client Satisfaction"]

# Axes Limits and Labels
xticklabels = ["Client Wins", "Case Reliability", "Efficiency", "Client Satisfaction"]
ylabel_value = "Performance Metric (%)"
ylim_values = [40, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(figsize=(8, 6))
bp = ax.boxplot(data, patch_artist=True, notch=False, showfliers=False)

# Customizing the boxplot colors
colors = ["#1f77b4", "#2ca02c", "#d62728", "#9467bd"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)

# Customizing the boxplot median lines
for median in bp["medians"]:
    median.set(color="black", linewidth=1.5)

legend_patches = [
    mpatches.Patch(color=color, label=label)
    for color, label in zip(colors, legend_labels)
]
ax.legend(handles=legend_patches, loc="upper right")

# Setting the x-axis labels
ax.set_xticklabels(xticklabels)

# Setting the y-axis label
ax.set_ylabel(ylabel_value)

# Setting the y-axis limits
ax.set_ylim(ylim_values)

# Adding grid lines
ax.yaxis.grid(True, which="major", color="grey", alpha=0.5)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_32.pdf", bbox_inches="tight")
