
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Sample data for weather domain
cities = ["City A", "City B", "City C", "City D", "City E", "City F"]
temperature = [22, 25, 21, 19, 23, 24]
rainfall = [120, 80, 90, 60, 100, 110]
humidity = [55, 65, 60, 58, 62, 59]
wind_speed = [10, 12, 9, 14, 11, 8]

# Generate random data for box plots based on the sample data
temp_data = [np.random.normal(temp, 2, 100) for temp in temperature]
rain_data = [np.random.normal(rain, 10, 100) for rain in rainfall]
humid_data = [np.random.normal(humid, 5, 100) for humid in humidity]
wind_data = [np.random.normal(wind, 1, 100) for wind in wind_speed]

xlabel = "Values"
titles = ["Temperature (°C)", "Rainfall (mm)", "Humidity (%)", "Wind Speed (km/h)"]
axhline = 0

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 3))
colors = ["#ff6666", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]

ax1 = plt.subplot(141)
ax2 = plt.subplot(142)
ax3 = plt.subplot(143)
ax4 = plt.subplot(144)

# Plotting
boxplot1 = ax1.boxplot(
    temp_data,
    vert=False,
    patch_artist=True,
    medianprops={"color": "black"},
    whiskerprops=dict(color="black", linestyle="-", linewidth=1),
    showcaps=False,
    showfliers=False,
    boxprops=dict(linestyle="-", linewidth=1),
)
boxplot2 = ax2.boxplot(
    rain_data,
    vert=False,
    patch_artist=True,
    medianprops={"color": "black"},
    whiskerprops=dict(color="black", linestyle="-", linewidth=1),
    showcaps=False,
    showfliers=False,
    boxprops=dict(linestyle="-", linewidth=1),
)
boxplot3 = ax3.boxplot(
    humid_data,
    vert=False,
    patch_artist=True,
    medianprops={"color": "black"},
    whiskerprops=dict(color="black", linestyle="-", linewidth=1),
    showcaps=False,
    showfliers=False,
    boxprops=dict(linestyle="-", linewidth=1),
)
boxplot4 = ax4.boxplot(
    wind_data,
    vert=False,
    patch_artist=True,
    medianprops={"color": "black"},
    whiskerprops=dict(color="black", linestyle="-", linewidth=1),
    showcaps=False,
    showfliers=False,
    boxprops=dict(linestyle="-", linewidth=1),
)

for bplot in [boxplot1, boxplot2, boxplot3, boxplot4]:
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# Set labels and titles
ax1.set_yticklabels(cities)
ax1.set_xlabel(xlabel)
ax1.set_title(titles[0])
ax1.spines["top"].set_visible(False)
ax1.spines["left"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.xaxis.grid(True, alpha=0.7)
ax1.invert_yaxis()

ax2.set_yticks([])
ax2.set_xlabel(xlabel)
ax2.set_title(titles[1])
ax2.spines["top"].set_visible(False)
ax2.spines["left"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.xaxis.grid(True, alpha=0.7)
ax2.invert_yaxis()

ax3.set_yticks([])
ax3.set_xlabel(xlabel)
ax3.set_title(titles[2])
ax3.spines["top"].set_visible(False)
ax3.spines["left"].set_visible(False)
ax3.spines["right"].set_visible(False)
ax3.xaxis.grid(True, alpha=0.7)
ax3.invert_yaxis()

ax4.set_yticks([])
ax4.set_xlabel(xlabel)
ax4.set_title(titles[3])
ax4.spines["top"].set_visible(False)
ax4.spines["left"].set_visible(False)
ax4.spines["right"].set_visible(False)
ax4.xaxis.grid(True, alpha=0.7)
ax4.invert_yaxis()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_36.pdf", bbox_inches="tight")
