
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# New sample data for population age distribution demonstration
data_region1 = [
    np.random.normal(30, 5, 100),  # Region 1, Socio-economic Condition A
    np.random.normal(35, 6, 100),  # Region 1, Socio-economic Condition B
    np.random.normal(25, 4, 100),  # Region 1, Socio-economic Condition C
]
data_region2 = [
    np.random.normal(40, 7, 100),  # Region 2, Socio-economic Condition A
    np.random.normal(45, 8, 100),  # Region 2, Socio-economic Condition B
    np.random.normal(38, 6, 100),  # Region 2, Socio-economic Condition C
]
data_region3 = [
    np.random.normal(55, 5, 100),  # Region 3, Socio-economic Condition A
    np.random.normal(60, 6, 100),  # Region 3, Socio-economic Condition B
    np.random.normal(50, 4, 100),  # Region 3, Socio-economic Condition C
]

# Positions of the boxplots
positions_region1 = [1, 5, 9]
positions_region2 = [2, 6, 10]
positions_region3 = [3, 7, 11]
xticklabels = ["Condition A", "Condition B", "Condition C"]
xticks = [2, 6, 10]
xlabel = "Socio-economic Conditions"
ylabel = "Age"
legend_labels = ["Region 1", "Region 2", "Region 3"]
ylim = [10, 80]
legendtitle = "Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, ax = plt.subplots(figsize=(10, 7))

# Plotting the boxplots
bp_region1 = ax.boxplot(
    data_region1,
    positions=positions_region1,
    widths=0.8,
    patch_artist=True,
    boxprops=dict(facecolor="#FF5733"),  # Nice different color
    medianprops=dict(color="blue", linewidth=2),
    showfliers=False,
)
bp_region2 = ax.boxplot(
    data_region2,
    positions=positions_region2,
    widths=0.8,
    patch_artist=True,
    boxprops=dict(facecolor="#33FFC1"),  # Nice different color
    medianprops=dict(color="blue", linewidth=2),
    showfliers=False,
)
bp_region3 = ax.boxplot(
    data_region3,
    positions=positions_region3,
    widths=0.8,
    patch_artist=True,
    boxprops=dict(facecolor="#338AFF"),  # Nice different color
    medianprops=dict(color="blue", linewidth=2),
    showfliers=False,
)

# Customizing the axes
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)
ax.yaxis.grid(True, linestyle="--", linewidth=0.5)
ax.xaxis.grid(True, linestyle="--", linewidth=0.5)

# Adding legend
ax.legend(
    [bp_region1["boxes"][0], bp_region2["boxes"][0], bp_region3["boxes"][0]],
    legend_labels,
    loc="upper right",
    title=legendtitle,
)

# Adding title
plt.title("Age Distribution Across Different Socio-economic Conditions in Various Regions")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_42.pdf", bbox_inches="tight")
