
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for the domain of philosophy
data_ancient = [
    np.random.normal(7, 1, 50),
    np.random.normal(6, 1, 50),
    np.random.normal(8, 1, 50),
]
data_modern = [
    np.random.normal(5, 1, 50),
    np.random.normal(7.5, 1, 50),
    np.random.normal(6.5, 1, 50),
]
data_contemporary = [
    np.random.normal(6, 1, 50),
    np.random.normal(5.5, 1, 50),
    np.random.normal(7, 1, 50),
]

# Positions of the boxplots
positions_ancient = [1, 5, 9]
positions_modern = [2, 6, 10]
positions_contemporary = [3, 7, 11]
xticklabels = ["Ideal", "Challenging", "Usual"]
xticks = [2, 6, 10]
xlabel = "Reading Conditions"
ylabel = "Books Read per Month"
legend_labels = ["Ancient Philosophers", "Modern Philosophers", "Contemporary Philosophers"]
ylim = [2, 12]
legendtitle = "Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, ax = plt.subplots(figsize=(10, 7))

# Plotting the boxplots
bp_ancient = ax.boxplot(
    data_ancient,
    positions=positions_ancient,
    widths=1,
    patch_artist=True,
    boxprops=dict(facecolor="#8B5A2B"),
    medianprops=dict(color="black"),
    showfliers=False,
)
bp_modern = ax.boxplot(
    data_modern,
    positions=positions_modern,
    widths=1,
    patch_artist=True,
    boxprops=dict(facecolor="#228B22"),
    medianprops=dict(color="black"),
    showfliers=False,
)
bp_contemporary = ax.boxplot(
    data_contemporary,
    positions=positions_contemporary,
    widths=1,
    patch_artist=True,
    boxprops=dict(facecolor="#DAA520"),
    medianprops=dict(color="black"),
    showfliers=False,
)

# Customizing the axes
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)
ax.yaxis.grid(True, linestyle="--", linewidth=0.5)
ax.xaxis.grid(True, linestyle="--", linewidth=0.5)

# Adding legend
ax.legend(
    [bp_ancient["boxes"][0], bp_modern["boxes"][0], bp_contemporary["boxes"][0]],
    legend_labels,
    loc="upper right",
    title=legendtitle,
)

# Adding title
plt.title("Books Read per Month by Different Groups of Philosophers under Various Conditions")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_43.pdf", bbox_inches="tight")
