
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate random data representing pollution levels in different cities
np.random.seed(42)
# Mean pollution levels for urban, suburban, and rural areas
urban_means = np.random.randint(50, 100, 9)
suburban_means = np.random.randint(20, 70, 9)
rural_means = np.random.randint(5, 30, 9)

# Generate pollution data with different standard deviations
urban_data = [
    np.random.normal(urban_means[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(5, 15), 9, replace=False))
]
suburban_data = [
    np.random.normal(suburban_means[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(5, 15), 9, replace=False))
]
rural_data = [
    np.random.normal(rural_means[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(5, 15), 9, replace=False))
]

# Titles and labels for the plots
titles = ["Urban Pollution Levels", "Suburban Pollution Levels", "Rural Pollution Levels"]
ylabel = "Pollutant Concentration (µg/m³)"
xticklabels = [
    "City A", "City B", "City C", "City D", "City E", 
    "City F", "City G", "City H", "City I"
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 3, figsize=(25, 8))

# Create a colormap with environmental colors
cmap = mcolors.LinearSegmentedColormap.from_list("env_cmap", ["#2E8B57", "#3CB371", "#66CDAA", "#8FBC8F", "#228B22", "#32CD32", "#98FB98", "#8A2BE2", "#5F9EA0"])

# Get 9 colors from the colormap
colors = cmap(np.linspace(0, 1, 9))

# Urban pollution levels subplot
bplot = axs[0].boxplot(urban_data, patch_artist=True)
axs[0].set_title(titles[0])
axs[0].set_ylabel(ylabel)
axs[0].set_xticklabels(
    xticklabels,
    rotation=45,
)

for patch, color in zip(bplot["boxes"], colors):
    patch.set_facecolor(color)

# Suburban pollution levels subplot
bplot1 = axs[1].boxplot(suburban_data, patch_artist=True)
axs[1].set_title(titles[1])
axs[1].set_xticklabels(
    xticklabels,
    rotation=45,
)
for patch, color in zip(bplot1["boxes"], colors):
    patch.set_facecolor(color)

# Rural pollution levels subplot
bplot2 = axs[2].boxplot(rural_data, patch_artist=True)
axs[2].set_title(titles[2])
axs[2].set_xticklabels(
    xticklabels,
    rotation=45,
)
for patch, color in zip(bplot2["boxes"], colors):
    patch.set_facecolor(color)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_45.pdf", bbox_inches="tight")
