
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Sample data for tourism domain
center_peak = np.random.randint(200, 300, 9)
center_off = np.random.randint(50, 100, 9)
center_mid = np.random.randint(100, 200, 9)

data_peak = [
    np.random.normal(center_peak[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(10, 30), 9, replace=False))
]
data_off = [
    np.random.normal(center_off[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(5, 15), 9, replace=False))
]
data_mid = [
    np.random.normal(center_mid[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(7, 20), 9, replace=False))
]

titles = ["Peak Season Tourism", "Off Season Tourism", "Mid-Season Tourism"]
ylabel = "Number of Tourists"
xticklabels = [
    "Place A",
    "Place B",
    "Place C",
    "Place D",
    "Place E",
    "Place F",
    "Place G",
    "Place H",
    "Place I",
]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 3, figsize=(25, 8))

# Colormap for tourism themes
cmap_tourism = mcolors.LinearSegmentedColormap.from_list(
    "tourism_cmap", ["#2E8B57", "#4682B4", "#FFA500"]
)
# Get 9 colors from the colormap
colors = cmap_tourism(np.linspace(0, 1, 9))

# Peak Season Tourism subplot
bplot_peak = axs[0].boxplot(data_peak, patch_artist=True)
axs[0].set_title(titles[0])
axs[0].set_ylabel(ylabel)
axs[0].set_xticklabels(xticklabels, rotation=45, fontsize=12)

for patch, color in zip(bplot_peak["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.6)

# Off Season Tourism subplot
bplot_off = axs[1].boxplot(data_off, patch_artist=True)
axs[1].set_title(titles[1])
axs[1].set_xticklabels(xticklabels, rotation=45, fontsize=12)
for patch, color in zip(bplot_off["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.6)

# Mid-Season Tourism subplot
bplot_mid = axs[2].boxplot(data_mid, patch_artist=True)
axs[2].set_title(titles[2])
axs[2].set_xticklabels(xticklabels, rotation=45, fontsize=12)
for patch, color in zip(bplot_mid["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_46.pdf", bbox_inches="tight")
