
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Setting the random seed for reproducibility
np.random.seed(0)

# Sample data simulating signal strength measurements
data1 = [
    np.random.normal(70, 5, 100),  # Urban Area
    np.random.normal(65, 7, 100),  # Urban Area
    np.random.normal(67, 6, 100)   # Urban Area
]

data2 = [
    np.random.normal(50, 6, 100),  # Rural Area
    np.random.normal(52, 5, 100),  # Rural Area
    np.random.normal(55, 4, 100)   # Rural Area
]

titles = ["Urban Area Signal Strength", "Rural Area Signal Strength"]
ylabels = ["Signal Strength (dB)", "Signal Strength (dB)"]
xticklabels = ["Provider A", "Provider B", "Provider C"]
yticks = [np.arange(50, 80, 5), np.arange(40, 60, 5)]


medianprops = dict(color="black", linestyle="--", linewidth=1.5)
boxprops = dict(color="blue", facecolor="lightblue")

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom size
fig, axs = plt.subplots(1, 2, figsize=(12, 6))
# Additional style parameters
color_scheme = ['#1f77b4', '#2ca02c', '#ff7f0e']  # Blue, Green, Orange
# Create the boxplots
for i, data in enumerate([data1, data2]):
    bp = axs[i].boxplot(data, medianprops=medianprops)
    
    # Customize boxplot colors
    for box in bp['boxes']:
        box.set(color=color_scheme[i % len(color_scheme)], linewidth=1.5)
    for whisker in bp['whiskers']:
        whisker.set(color=color_scheme[i % len(color_scheme)], linestyle="--")
    for cap in bp['caps']:
        cap.set(color=color_scheme[i % len(color_scheme)])
    for flier in bp['fliers']:
        flier.set(marker='o', color=color_scheme[i % len(color_scheme)], alpha=0.5)
    for median in bp['medians']:
        median.set(color='black', linewidth=1.5)

    # Set titles and labels
    axs[i].set_title(titles[i])
    axs[i].set_ylabel(ylabels[i])
    axs[i].set_xticklabels(xticklabels, rotation=45)
    axs[i].set_yticks(yticks[i])
    axs[i].grid(True, linestyle="--", linewidth=0.7, alpha=0.7)

# Adjust layout for better spacing
plt.subplots_adjust(left=0.08, right=0.92, top=0.9, bottom=0.1, wspace=0.4)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("box_50.pdf", bbox_inches="tight")
