
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for the boxplots
data_heart_rate = [
    np.random.normal(70, 5, 100),  # Regime 1
    np.random.normal(75, 5, 100),  # Regime 2
    np.random.normal(68, 5, 100),  # Regime 3
]
data_blood_pressure = [
    np.random.normal(120, 8, 100), # Regime 1
    np.random.normal(125, 8, 100), # Regime 2
    np.random.normal(118, 8, 100), # Regime 3
]

titles = ["Heart Rate Comparison", "Blood Pressure Comparison"]
ylabels = ["Heart Rate (bpm)", "Blood Pressure (mmHg)"]
xticklabels = ["Regime 1", "Regime 2", "Regime 3"]
yticks_heart_rate = np.arange(55, 85, 5)
yticks_blood_pressure = np.arange(100, 140, 5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom size
fig, axs = plt.subplots(1, 2, figsize=(12, 6))

# Create the boxplots
bp1 = axs[0].boxplot(data_heart_rate, medianprops=dict(color="green"), 
                     boxprops=dict(color='blue'), whiskerprops=dict(color='blue'), capprops=dict(color='blue'), flierprops=dict(marker='o', color='red', alpha=0.5))
bp2 = axs[1].boxplot(data_blood_pressure, medianprops=dict(color="green"), 
                     boxprops=dict(color='blue'), whiskerprops=dict(color='blue'), capprops=dict(color='blue'), flierprops=dict(marker='o', color='red', alpha=0.5))

# Set titles for subplots
axs[0].set_title(titles[0])
axs[1].set_title(titles[1])

# Set y-axis labels
axs[0].set_ylabel(ylabels[0])
axs[1].set_ylabel(ylabels[1])

# Set y-axis ticks
axs[0].set_yticks(yticks_heart_rate)
axs[1].set_yticks(yticks_blood_pressure)

# Set x-axis labels
axs[0].set_xticklabels(xticklabels, rotation=45)
axs[1].set_xticklabels(xticklabels, rotation=45)

# Add grids
axs[0].grid(True, linestyle='--', alpha=0.7)
axs[1].grid(True, linestyle='--', alpha=0.7)

# Adjust layout to improve spacing
plt.subplots_adjust(left=0.1, right=0.9, top=0.9, bottom=0.15, wspace=0.4)

# Add a super title
plt.suptitle("Comparison of Health Metrics Across Different Exercise Regimes", fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("box_51.pdf", bbox_inches="tight")
