
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data for the boxplots (representing stock prices over a week)
data1 = [150.5, 151.0, 149.5, 150.0, 152.0, 151.5, 150.8]  # Stock A
data2 = [148.0, 148.5, 148.8, 149.0, 148.6, 149.2, 148.9]  # Stock B
xticklabels = ["Stock A\n(Daily Close)", "Stock B\n(Daily Close)"]
ylabel = "Price (USD)"
xlabel = "Stocks"
title = "Stock Market Analysis\n(Daily Closing Prices)"
sublabel = "Week 1"
textlabel = "1.5 USD"
hlines = [150.8, 149.3]
ylim = [147, 153]
yticks = [147, 148, 149, 150, 151, 152, 153]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified dimensions
fig, ax = plt.subplots(figsize=(8, 6))

# Create the boxplots with custom colors
colors = ['#1f77b4', '#2ca02c']  # Blue and Green
bp1 = ax.boxplot(
    data1, positions=[1], widths=0.6, patch_artist=True, 
    boxprops=dict(facecolor=colors[0], alpha=0.6),
    medianprops=dict(color='black')
)
bp2 = ax.boxplot(
    data2, positions=[2], widths=0.6, patch_artist=True,
    boxprops=dict(facecolor=colors[1], alpha=0.6),
    medianprops=dict(color='black')
)

# Set the labels for the x-axis
ax.set_xticklabels(xticklabels, ha="center")

# Set the labels for the y-axis and x-axis
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)

# Set the y-axis limits and ticks
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Add a custom annotation for the 1.5 USD difference
ax.annotate(
    "",
    xy=(2.25, 150.8),
    xytext=(2.25, 149.3),
    arrowprops=dict(facecolor="black", arrowstyle="->"),
    horizontalalignment="center",
)

# Add the text for the 1.5 USD difference
ax.text(2.5, 149.9, textlabel, horizontalalignment="center")

# Add the dashed line for the 1.5 USD difference
ax.hlines(hlines[0], 1, 2.25, colors="grey", linestyles="dashed")
ax.hlines(hlines[1], 2, 2.25, colors="grey", linestyles="dashed")

# Add the title and subtitle
fig.suptitle(title)
fig.text(0.5, 0.94, sublabel, ha='center', fontsize=12, color='grey')

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and show the plot
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("box_57.pdf", bbox_inches="tight")
