
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data for the boxplots (adherence levels for two religious groups)
data1 = [7, 8, 7.5, 8.5, 8, 9, 8]
data2 = [6, 7, 7, 6.5, 7.2, 6.8, 7]

# Label configurations
xticklabels = ["Group A\n(Belief A)", "Group B\n(Belief B)"]
xlabel = "Religious Groups"
ylabel = "Adherence Level"
xlim = [0.5, 3]
ylim = [5, 10]
yticks = [5, 6, 7, 8, 9, 10]
textlabel = "1.0 Level "
hlines = [8.5, 7.5]
title = "Comparison of Adherence Levels Between Two Groups"
legendlabels = ["Group A", "Group B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified dimensions
fig, ax = plt.subplots(figsize=(6, 4))

# Create the boxplots with custom colors
bp1 = ax.boxplot(
    data1, positions=[1], widths=0.6, patch_artist=True, 
    boxprops=dict(facecolor="#5DA5DA")
)
bp2 = ax.boxplot(
    data2, positions=[2], widths=0.6, patch_artist=True, 
    boxprops=dict(facecolor="#FAA43A")
)

# Set the labels for the x-axis
ax.set_xticklabels(xticklabels, ha="center")
ax.set_xlim(xlim)

# Set the labels for the y-axis and chart title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Set the y-axis limits and ticks
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Add a custom annotation for the 1.0 Level difference
ax.annotate(
    "",
    xy=(2.25, 8.5),
    xytext=(2.25, 7.5),
    arrowprops=dict(facecolor="black", arrowstyle="->"),
    horizontalalignment="center",
)

# Add the text for the 1.0 Level difference
ax.text(2.5, 7.9, textlabel, horizontalalignment="center")

# Add the dashed line for the 1.0 Level difference
ax.hlines(hlines[0], 1, 2.25, colors="grey", linestyles="dashed")
ax.hlines(hlines[1], 2, 2.25, colors="grey", linestyles="dashed")

# Add a legend
ax.legend([bp1["boxes"][0], bp2["boxes"][0]], legendlabels, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and show the plot
plt.tight_layout()
plt.savefig("box_58.pdf", bbox_inches="tight")
