
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Sample data for the boxplots (synthetic data for voter approval ratings)
data = [
    np.random.normal(50, 10, size=100),  # Party 1
    np.random.normal(55, 12, size=100),  # Party 2
    np.random.normal(60, 15, size=100),  # Party 3
    np.random.normal(45, 10, size=100),  # Party 4
    np.random.normal(70, 8 , size=100),  # Party 5
]

# Party names for the x-axis
categories = [
    "Party A",
    "Party B",
    "Party C",
    "Party D",
    "Party E",
]

# Axes Limits and Labels
xticks_values = range(1, len(categories) + 1)
ylim_values = [20, 110]
yticks_values = list(range(20, 120, 10))
yticks_label = [str(i) for i in yticks_values]
ylabel_value = "Approval Rating (%)"
xlabel_value = "Political Parties"
title_value = "Voter Approval Ratings by Political Parties"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
plt.figure(figsize=(10, 8))  # Size in inches
boxprops = dict(linestyle='-', linewidth=2, color='black')
medianprops = dict(color='red', linewidth=2)
meanpointprops = dict(marker='D', markeredgecolor='black', markerfacecolor='firebrick')

plt.boxplot(data, boxprops=boxprops, medianprops=medianprops, meanline=False, showmeans=True, meanprops=meanpointprops,
            patch_artist=True, notch=True)

# Set the x-axis labels and title
plt.xticks(xticks_values, categories, fontsize=12)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylim(ylim_values)
plt.yticks(yticks_values, yticks_label)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16)

# Adding grid for better readability
plt.grid(which='both', linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_59.pdf", bbox_inches="tight")
