
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Generated sample data for tourism ratings (1 to 5) for different destinations
data = [
    [3.8, 4.0, 4.2, 4.5, 4.7],
    [3.5, 3.7, 3.9, 4.1, 4.3],
    [4.0, 4.2, 4.5, 4.7, 4.9],
    [3.2, 3.5, 3.8, 4.0, 4.2],
    [4.1, 4.3, 4.5, 4.8, 5.0],
]

# Category names for the x-axis
categories = [
    "Beach",
    "Mountain",
    "City",
    "Safari",
    "Island",
]

# Axes Limits and Labels
xticks_values = range(1, len(categories) + 1)
ylim_values = [2.5, 5.5]
yticks_values = [2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5]
yticks_label = ["2.5", "3.0", "3.5", "4.0", "4.5", "5.0", "5.5"]
ylabel_value = "Tourist Ratings (1-5)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
plt.figure(figsize=(10, 7))  # Adjusted size for better readability
plt.boxplot(data, 
            medianprops=dict(color="darkgreen"),
            boxprops=dict(color="blue", linewidth=2),
            whiskerprops=dict(color="blue", linewidth=1.5),
            capprops=dict(color="blue", linewidth=1.5))

# Set the x-axis labels
plt.xticks(xticks_values, categories, fontweight='bold')
plt.ylim(ylim_values)
plt.yticks(yticks_values, yticks_label)
# Set the y-axis label
plt.ylabel(ylabel_value, fontsize=12, fontweight='bold')

# Add a title
plt.title("Customer Ratings for Tourist Destinations", fontsize=14, fontweight='bold')

# Enhance grid appearance
plt.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_60.pdf", bbox_inches="tight")
