
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for satisfaction ratings with different government services
data = [
    np.random.normal(7.5, 0.8, 100),  # Healthcare
    np.random.normal(6.8, 0.7, 100),  # Education
    np.random.normal(7.0, 0.9, 100),  # Public Transportation
    np.random.normal(8.2, 0.6, 100),  # Security
    np.random.normal(6.5, 0.8, 100),  # Environmental Policies
]

labels = ["Healthcare", "Education", "Public Transportation", "Security", "Environmental Policies"]
ylabel = "Satisfaction Rating"
xlabel = "Government Services"
title = "Public Satisfaction with Government Services"
ylim = [4, 10]
yticks = np.arange(4, 10.1, 0.5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(figsize=(8, 6))

# Color palette
colors = ["#8fdcc5", "#f4a259", "#f76d6d", "#729b79", "#a8d7c9"]

# Create boxplot with new styling
bp = ax.boxplot(
    data,
    labels=labels,
    patch_artist=True,
    boxprops=dict(facecolor=colors[0], color="black"),
    medianprops=dict(color="black"),
    whiskerprops=dict(color="black", linestyle="-"),
    capprops=dict(color="black", linestyle="-"),
)

for patch, color in zip(bp['boxes'], colors):
    patch.set_facecolor(color)

# Remove outliers
for flier in bp["fliers"]:
    flier.set(marker="", color="black")

# Set the y-axis range and tick labels
ax.set_ylim(ylim)
ax.set_yticks(yticks)
# Set the x and y-axis label
ax.set_ylabel(ylabel, fontsize=14)
ax.set_xlabel(xlabel, fontsize=14)
# Set plot title
ax.set_title(title, fontsize=16)

# Set the tick label size
ax.tick_params(axis="both", which="major", labelsize=12)
plt.xticks(rotation=30, ha='right')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("box_62.pdf", bbox_inches="tight")
