
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Sample data for finance domain
stock_changes = [
    np.random.normal(0.02, 0.05, 100),
    np.random.normal(0.015, 0.04, 100),
    np.random.normal(0.01, 0.03, 100),
]
trading_volumes = [
    np.random.normal(30, 5, 100),
    np.random.normal(45, 10, 100),
    np.random.normal(50, 15, 100),
]

# Labels and titles
titles = ["Stock Price Percentage Changes", "Daily Trading Volume (Millions)"]
xticklabels = ["Q1", "Q2", "Q3"]
ylabels = ["Percentage Change", "Volume (Millions)"]
yticks = [np.arange(-0.1, 0.15, 0.05), np.arange(0, 80, 10)]
ylims = [[-0.1, 0.15], [0, 80]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots with specified figure size
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
medianprops = dict(linestyle="-", linewidth=1, color="black")
# Left subplot - Stock Price Percentage Changes
bplot1 = ax1.boxplot(
    stock_changes,
    patch_artist=True,
    showfliers=True,
    widths=0.6,
    medianprops=medianprops,
    flierprops=dict(marker="o", color="black", markerfacecolor="black", markersize=4),
)
ax1.set_title(titles[0])
ax1.set_xticklabels(xticklabels)
ax1.set_ylabel(ylabels[0])
ax1.set_yticks(yticks[0])
ax1.set_ylim(ylims[0])
ax1.set_facecolor("#f7f7f7")
ax1.yaxis.grid(True, color="gray", linestyle='--', linewidth=0.5)

# Add median value annotations
for i, line in enumerate(bplot1["medians"]):
    x, y = line.get_xydata()[1]
    ax1.text(x-0.3, y+0.005, f"{y:.2%}", horizontalalignment="center", color="black", fontsize=8)

# Right subplot - Daily Trading Volume
bplot2 = ax2.boxplot(
    trading_volumes,
    patch_artist=True,
    showfliers=True,
    widths=0.6,
    medianprops=medianprops,
    flierprops=dict(marker="o", color="black", markerfacecolor="black", markersize=4),
)
ax2.set_title(titles[1])
ax2.set_xticklabels(xticklabels)
ax2.set_ylabel(ylabels[1])
ax2.set_yticks(yticks[1])
ax2.set_ylim(ylims[1])
ax2.set_facecolor("#f7f7f7")
ax2.yaxis.grid(True, color="gray", linestyle='--', linewidth=0.5)

# Add median value annotations
for i, line in enumerate(bplot2["medians"]):
    x, y = line.get_xydata()[1]
    ax2.text(x-0.3, y+1, f"{y:.2f}", horizontalalignment="center", color="black", fontsize=8)

# Set colors for boxplots
colors = ["#4CAF50", "#FF5722", "#2196F3"]
for bplot in (bplot1, bplot2):
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.tight_layout()
plt.savefig("box_65.pdf", bbox_inches="tight")
