
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for demonstration purposes in the energy domain
energy_consumption = [
    np.random.normal(200, 20, 100),
    np.random.normal(180, 25, 100),
    np.random.normal(220, 15, 100),
]
energy_efficiency = [
    np.random.normal(85, 5, 100),
    np.random.normal(75, 7, 100),
    np.random.normal(90, 4, 100),
]

titles = ["Energy Consumption (kWh)", "Energy Efficiency (%)"]
xticklabels = ["Residential", "Commercial", "Industrial"]
ylabels = ["kWh Consumption", "Efficiency (%)"]
yticks = [np.arange(150, 251, 25), np.arange(60, 101, 10)]
ylims = [[150, 250], [60, 100]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots with specified figure size
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
medianprops = dict(linestyle="-", linewidth=1.5, color="black")
# Left subplot - Energy Consumption
bplot1 = ax1.boxplot(
    energy_consumption,
    patch_artist=True,
    showfliers=True,
    widths=0.6,
    medianprops=medianprops,
    flierprops=dict(marker="o", color="black", markerfacecolor="black", markersize=6),
)
ax1.set_title(titles[0])
ax1.set_xticklabels(xticklabels)
ax1.set_ylabel(ylabels[0])
ax1.set_yticks(yticks[0])
ax1.set_ylim(ylims[0])
ax1.set_facecolor("#f2f2f2")
ax1.yaxis.grid(True, color="#d9d9d9")

# Add median value annotations
for i, line in enumerate(bplot1["medians"]):
    x, y = line.get_xydata()[1]
    ax1.text(x-0.3, y+1, f"{y:.1f}", horizontalalignment="center", color="black", weight='bold')

# Right subplot - Energy Efficiency
bplot2 = ax2.boxplot(
    energy_efficiency,
    patch_artist=True,
    showfliers=True,
    widths=0.6,
    medianprops=medianprops,
    flierprops=dict(marker="o", color="black", markerfacecolor="black", markersize=6),
)
ax2.set_title(titles[1])
ax2.set_xticklabels(xticklabels)
ax2.set_ylabel(ylabels[1])
ax2.set_yticks(yticks[1])
ax2.set_ylim(ylims[1])
ax2.set_facecolor("#f2f2f2")
ax2.yaxis.grid(True, color="#d9d9d9")

# Add median value annotations
for i, line in enumerate(bplot2["medians"]):
    x, y = line.get_xydata()[1]
    ax2.text(x-0.3, y+1, f"{y:.1f}", horizontalalignment="center", color="black", weight='bold')

# Set colors for boxplots
colors = ["#66c2a5", "#fc8d62", "#8da0cb"]
for bplot in (bplot1, bplot2):
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.tight_layout()
plt.savefig("box_67.pdf", bbox_inches="tight")
