
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate sample data for quarterly profit margins across departments
departments = ["Sales", "Marketing", "Development", "Support", "HR"]
center_values = np.random.uniform(10, 20, len(departments))
data = [np.random.normal(center, 2, 100) for center in center_values]
xticklabels = departments
ylabel = "Quarterly Profit Margin (%)"
xhline = 15

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified dimensions
fig, ax = plt.subplots(figsize=(10, 6))

medianprops = dict(linestyle="-", linewidth=2, color="black")

# Choose a professional color palette
colors = ["#4c72b0", "#55a868", "#c44e52", "#8172b2", "#ccb974"]

# Boxplot with custom colors
box = ax.boxplot(data, patch_artist=True, medianprops=medianprops)
for patch, color in zip(box["boxes"], colors):
    patch.set_facecolor(color)

# Add threshold line
ax.axhline(xhline, color="red", linestyle="--", linewidth=2, label="Target Margin")

# Set x-axis labels
ax.set_xticklabels(xticklabels, fontsize=12)

# Set y-axis label
ax.set_ylabel(ylabel, fontsize=14)

# Title for the chart
ax.set_title("Quarterly Profit Margins by Department", fontsize=16)

# Add legend for the threshold line
ax.legend(loc="upper right", frameon=False, fontsize=12)

# Adding grid for better readability
ax.grid(True, linestyle="--", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("box_70.pdf", bbox_inches="tight")
