
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
philosophical_theories = [
    "Existentialism",
    "Nihilism",
    "Stoicism",
    "Absurdism",
    "Rationalism",
    "Empiricism",
    "Idealism",
    "Materialism",
    "Structuralism",
    "Postmodernism",
][::-1]

# Generate scores with plausible trends and distributions, considering a normalized scale
scores = [
    np.random.uniform(-5, 5, 10) for _ in philosophical_theories * 2
]
scores = [(score - np.min(score)) / (np.max(score) - np.min(score)) for score in scores]

xlabels = ["one by one assessment", "combined assessment"]
ylims = [[0, 11], [0, 11]]
xlims = [[-0.05, 1.05], [-0.05, 1.05]]

yticks = [range(1, len(philosophical_theories) + 1), range(1, len(philosophical_theories) + 1)]

# Labels, Titles and Legends
suptitle = "Philosophical Theories Assessment"
xlabel1 = "one by one assessment"
xlabel2 = "combined assessment"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure and Axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6), sharey=True)
medianprops = dict(linestyle="--", linewidth=1.5, color="black")
colors = [
    "#6a3d9a",
    "#cab2d6",
    "#ff7f00",
    "#fdbf6f",
    "#b15928",
    "#ffff99",
    "#1f78b4",
    "#a6cee3",
    "#b2df8a",
    "#33a02c",
][::-1]
backcolors = ["#f3e5f5", "#ffe0b2", "#c5cae9", "#dcedc8"][::-1]

# Subplot 1: one by one
bplot1 = ax1.boxplot(
    scores[:10], vert=False, medianprops=medianprops, patch_artist=True
)
ax1.set_ylim(ylims[0])
ax1.set_yticks(yticks[0])
ax1.set_yticklabels(philosophical_theories)
ax1.set_xlim(xlims[0])
ax1.set_xlabel(xlabel1)
ax1.set_facecolor("#f9f9f9")
ax1.xaxis.grid(True)
ax1.set_axisbelow(True)

for patch, color in zip(bplot1["boxes"], colors):
    patch.set_facecolor(color)

# Set background colors
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 0.5), 1.1, 1.5, facecolor=backcolors[0], edgecolor="none", zorder=0
    )
)
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 1.5), 1.1, 1.5, facecolor=backcolors[1], edgecolor="none", zorder=0
    )
)
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 2.5), 1.1, 5.5, facecolor=backcolors[2], edgecolor="none", zorder=0
    )
)
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 7.5), 1.1, 3, facecolor=backcolors[3], edgecolor="none", zorder=0
    )
)


# Subplot 2: all in one
bplot2 = ax2.boxplot(
    scores[10:], vert=False, medianprops=medianprops, patch_artist=True
)
ax2.set_ylim(ylims[1])
ax2.set_yticks(yticks[1])
ax2.set_yticklabels(philosophical_theories)
ax2.set_xlim(xlims[1])
ax2.set_xlabel(xlabel2)
ax2.set_facecolor("#f9f9f9")
ax2.xaxis.grid(True)
ax2.set_axisbelow(True)

for patch, color in zip(bplot2["boxes"], colors):
    patch.set_facecolor(color)

# Set background colors
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 0.5), 1.1, 1.5, facecolor=backcolors[0], edgecolor="none", zorder=0
    )
)
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 1.5), 1.1, 1.5, facecolor=backcolors[1], edgecolor="none", zorder=0
    )
)
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 2.5), 1.1, 5.5, facecolor=backcolors[2], edgecolor="none", zorder=0
    )
)
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 7.5), 1.1, 3, facecolor=backcolors[3], edgecolor="none", zorder=0
    )
)

# Gradient background
for ax in [ax1, ax2]:
    ax.set_facecolor("white")

# Set supertitle
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("box_78.pdf", bbox_inches="tight")
