
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for the education domain (test scores)
data_high_school = np.random.normal(75, 10, 50)
data_undergraduate = np.random.normal(80, 12, 50)
data_graduate = np.random.normal(85, 8, 50)

data = [data_high_school, data_undergraduate, data_graduate]
ylabel = "Test Scores"
xticklabels = ["Traditional", "Online", "Hybrid"]
xticks = [1, 2, 3]
ylim = [40, 120]
categories = ["High School", "Undergraduate", "Graduate"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to appropriately display data
plt.figure(figsize=(12, 6))

# Define colors for each boxplot
colors = ["#ff9999", "#66b3ff", "#99ff99"]

# Create subplots for each category
for i, category in enumerate(categories, 1):
    plt.subplot(1, 3, i)
    bplot = plt.boxplot(
        data,
        patch_artist=True,
        widths=0.7,
        medianprops=dict(color="black"),
        whiskerprops=dict(color="black"),
        capprops=dict(color="black"),
    )

    # Set colors for each box
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

    # Scatter plot for data points
    for j in range(1, 4):
        y = data[j - 1]
        x = np.random.normal(j, 0.04, size=len(y))
        plt.plot(x, y, "k.", alpha=0.6)

    plt.title(category)
    plt.xticks(xticks, xticklabels)
    plt.ylim(ylim)
    if i == 1:
        plt.ylabel(ylabel)
    plt.gca().xaxis.grid(True)
    plt.gca().spines["top"].set_visible(False)
    plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.tight_layout()
plt.savefig("box_80.pdf", bbox_inches="tight")
