
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Placeholder data for the boxplots - Psychology cognitive test results
data1 = [np.random.normal(55, 10, 100), np.random.normal(65, 12, 100)]
data2 = [np.random.normal(500, 50, 100), np.random.normal(520, 55, 100)]
data3 = [np.random.normal(75, 8, 100), np.random.normal(80, 7, 100)]
data4 = [np.random.normal(45, 5, 100), np.random.normal(50, 6, 100)]
data5 = [np.random.normal(120, 20, 100), np.random.normal(110, 15, 100)]
titles = [
    "Memory Recall",
    "Reaction Time",
    "Problem Solving",
    "Attention Span",
    "Stress Response",
]
xticklabels = ["Group A", "Group B"]
xticks = [1, 2]
xlabel = "Test Group"
ylabels = (
    "Score (0-100)",
    "Time (ms)",
    "Score (0-100)",
    "Duration (s)",
    "Score (0-200)",
)

# Plot colors
colors = ["#4c72b0", "#55a868"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom dimensions
fig, axs = plt.subplots(1, 5, figsize=(15, 5))  # Adjusted for clarity

# Plot the boxplots with the specified colors and outlier shapes
for i, data in enumerate([data1, data2, data3, data4, data5]):
    bplot = axs[i].boxplot(
        data,
        patch_artist=True,
        notch=False,
        widths=0.7,
        medianprops=dict(color="black"),
        flierprops=dict(
            marker="o", color="black", markerfacecolor="red", markersize=5
        ),
    )
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)
        patch.set_alpha(0.7)

# Set the titles for each subplot
for i, ax in enumerate(axs):
    ax.set_title(titles[i])
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.set_xlabel(xlabel)
    ax.grid(True, linestyle='--', alpha=0.6)

# Set the y-axis labels
for i, ylabel in enumerate(ylabels):
    axs[i].set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout()
plt.savefig("box_83.pdf", bbox_inches="tight")
