
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)

# Placeholder data for the boxplots (Historical Weather Data)
data1 = [np.random.normal(15, 5, 100), np.random.normal(20, 5, 100)]  # Temperature
data2 = [np.random.normal(60, 10, 100), np.random.normal(55, 10, 100)]  # Humidity
data3 = [np.random.normal(10, 2, 100), np.random.normal(12, 2, 100)]  # Wind Speed
data4 = [np.random.normal(5, 1, 100), np.random.normal(8, 1, 100)]  # Precipitation
data5 = [np.random.normal(1010, 10, 100), np.random.normal(1005, 10, 100)]  # Air Pressure

titles = [
    "Temperature Distribution",
    "Humidity Levels",
    "Wind Speed Distribution",
    "Precipitation Amounts",
    "Air Pressure Levels",
]
xticklabels = ["City A", "City B"]
xticks = [1, 2]
xlabel = "City"
ylabels = (
    "Temperature (°C)",
    "Humidity (%)",
    "Wind Speed (km/h)",
    "Precipitation (mm)",
    "Air Pressure (hPa)",
)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom dimensions to match the original image
fig, axs = plt.subplots(1, 5, figsize=(15, 5))  # Adjusted for clarity

# Define colors for the boxplots
colors = ["#4682B4", "#32CD32"]

# Plot the boxplots with the specified colors and outlier shapes
for i, data in enumerate([data1, data2, data3, data4, data5]):
    bplot = axs[i].boxplot(
        data,
        patch_artist=True,
        notch=False,
        widths=0.7,
        medianprops=dict(color="black"),
        flierprops=dict(
            marker="o", color="red", markerfacecolor="red", markersize=5
        ),
    )
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# Set the titles for each subplot
axs[0].set_title(titles[0])
axs[1].set_title(titles[1])
axs[2].set_title(titles[2])
axs[3].set_title(titles[3])
axs[4].set_title(titles[4])

# Set the x-axis labels with proper spacing
for ax in axs:
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.set_xlabel(xlabel)

# Set the y-axis labels
axs[0].set_ylabel(ylabels[0])
axs[1].set_ylabel(ylabels[1])
axs[2].set_ylabel(ylabels[2])
axs[3].set_ylabel(ylabels[3])
axs[4].set_ylabel(ylabels[4])

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout()
plt.savefig("box_84.pdf", bbox_inches="tight")
