
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Placeholder data for the boxplots in the agriculture domain
data1 = [np.random.normal(3000, 500, 100), np.random.normal(3200, 600, 100)]  # Crop Yield (kg/ha)
data2 = [np.random.normal(30, 5, 100), np.random.normal(35, 6, 100)]  # Soil Moisture (%)
data3 = [np.random.normal(150, 20, 100), np.random.normal(160, 25, 100)]  # Plant Height (cm)
data4 = [np.random.normal(25, 5, 100), np.random.normal(27, 6, 100)]  # Leaf Area (cm^2)
data5 = [np.random.normal(30, 7, 100), np.random.normal(28, 8, 100)]  # Root Length (cm)

# Titles and labels to match the agriculture data
titles = [
    "Crop Yield",
    "Soil Moisture",
    "Plant Height",
    "Leaf Area",
    "Root Length",
]
xticklabels = ["Region A", "Region B"]
xticks = [1, 2]
xlabel = "Regions"
ylabels = (
    "Yield (kg/ha)",
    "Moisture (%)",
    "Height (cm)",
    "Area (cm^2)",
    "Length (cm)",
)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom dimensions to match the original image
fig, axs = plt.subplots(1, 5, figsize=(15, 7))  # Adjusted dimensions

# Define colors for the boxplots
colors = ["#2ca02c", "#8c564b"]  # Green and Brown colors for agriculture

# Plot the boxplots with the specified colors and outlier shapes
for i, data in enumerate([data1, data2, data3, data4, data5]):
    bplot = axs[i].boxplot(
        data,
        patch_artist=True,
        notch=False,
        widths=0.7,
        medianprops=dict(color="black"),
        flierprops=dict(
            marker="o", color="black", markerfacecolor="black", markersize=5
        ),
    )
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# Set the titles for each subplot
for ax, title in zip(axs, titles):
    ax.set_title(title, fontsize=12, fontweight='bold')

# Set the x-axis labels with proper spacing
for ax in axs:
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels, fontsize=10)
    ax.set_xlabel(xlabel, fontsize=10)

# Set the y-axis labels
for ax, ylabel in zip(axs, ylabels):
    ax.set_ylabel(ylabel, fontsize=10)
    ax.grid(True)  # Add grid for better readability

# Set a common super title
plt.suptitle("Agricultural Metrics", fontsize=16, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])  # Adjust rect to make space for suptitle
plt.savefig("box_85.pdf", bbox_inches="tight")
