
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate synthetic health metrics data
data = [
    np.random.normal(120, 15, 100),  # Blood Pressure
    np.random.normal(75, 10, 100),   # Heart Rate
    np.random.normal(200, 30, 100),  # Cholesterol Levels
    np.random.normal(25, 5, 100),    # BMI
    np.random.normal(100, 20, 100),  # Glucose Levels
]

labels = ["Blood Pressure", "Heart Rate", "Cholesterol Levels", "BMI", "Glucose Levels"]

# Axes Limits and Labels
ylim_values = [0, 250]
xlabel_value = "Health Metrics"
ylabel_value = "Measurement Units"
title_value = "Distribution of Various Health Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(figsize=(10, 6))

# Customizing the color scheme and elements
colors = ['#66c2a5', '#fc8d62', '#8da0cb', '#e78ac3', '#a6d854']
bp = ax.boxplot(
    data,
    labels=labels,
    patch_artist=True,
    boxprops=dict(facecolor='white', color='black'),
    showfliers=False,
    showcaps=False,
    medianprops=dict(color="black"),
    whiskerprops=dict(color="black", linestyle="-", linewidth=0),
    capprops=dict(color="black", linestyle="-"),
)

for patch, color in zip(bp['boxes'], colors):
    patch.set_facecolor(color)

ax.set_ylim(ylim_values)
# Set labels
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title_value)

# Set grid
ax.grid(True)

# Add a legend
handles = [plt.Line2D([0], [0], color=color, lw=4) for color in colors]
legend_labels = labels
ax.legend(handles, legend_labels, loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_89.pdf", bbox_inches="tight")
