
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new data (agriculture domain: crop yields under different fertilizer amounts)
data = [
    np.random.normal(4.5, 0.5, 100),  # Fertilizer level 50 kg/ha
    np.random.normal(5.0, 0.6, 100),  # Fertilizer level 100 kg/ha
    np.random.normal(5.8, 0.4, 100),  # Fertilizer level 150 kg/ha
    np.random.normal(6.0, 0.35, 100),  # Fertilizer level 200 kg/ha
    np.random.normal(6.2, 0.5, 100),  # Fertilizer level 350 kg/ha
]

labels = ["50", "100", "150", "200", "350"]

# Axes Limits and Labels
ylim_values = [3.0, 7.0]
xlabel_value = "Fertilizer Amount (kg/ha)"
ylabel_value = "Yield (tons/ha)"
title = "Effect of Different Fertilizer Amounts on Crop Yield"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size
bp = ax.boxplot(
    data,
    labels=labels,
    patch_artist=True,
    boxprops=dict(facecolor="#66c2a5", color="black"),
    showfliers=False,
    showcaps=False,
    medianprops=dict(color="black"),
    whiskerprops=dict(color="black", linestyle="-", linewidth=1),
    capprops=dict(color="black", linestyle="-"),
)

# Set individual box colors
colors = ["#fee08b", "#fdae61", "#f46d43", "#d73027", "#a50026"]
for patch, color in zip(bp['boxes'], colors):
    patch.set_facecolor(color)

# Set labels and title
ax.set_ylim(ylim_values)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)

# Set grid
ax.grid(True, linestyle='--', linewidth=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_91.pdf", bbox_inches="tight")
