
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample geographic data
data = {
    "Elevation (m)": np.random.rand(6, 6) * 2000 + 500,
    "Average Temperature (°C)": np.random.rand(6, 6) * 10 + 15,
    "Rainfall (mm)": np.random.rand(6, 6) * 300 + 200,
    "Humidity (%)": np.random.rand(6, 6) * 30 + 40,
}

# Geographical regions
labels = [
    "Region A",
    "Region B",
    "Region C",
    "Region D",
    "Region E",
    "Region F",
]

# Titles and labels
xlabel = "Geographical Regions"
ylabel = {
    "Elevation (m)": "Elevation (m)",
    "Average Temperature (°C)": "Temperature (°C)",
    "Rainfall (mm)": "Rainfall (mm)",
    "Humidity (%)": "Humidity (%)",
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8c564b", "#e377c2", "#7f7f7f", "#bcbd22", "#17becf", "#1f77b4"]

fig, axes = plt.subplots(2, 2, figsize=(10, 10), constrained_layout=True)

for i, (ax, (metric, values)) in enumerate(zip(axes.flatten(), data.items())):
    bplot = ax.boxplot(
        values,
        vert=True,
        patch_artist=True,
        showcaps=False,
        showfliers=False,
        whiskerprops=dict(color="gray", linestyle="--", linewidth=1),
        medianprops={"color": "red", "linewidth": 2},
        boxprops=dict(linestyle="-", linewidth=1.5),
    )
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)
    ax.set_title(metric)
    ax.set_ylabel(ylabel[metric])
    if i == 2 or i == 3:
        ax.set_xticklabels(labels, rotation=45)
    else:
        ax.set_xticks([])
    ax.yaxis.grid(True, alpha=0.7)
    ax.xaxis.grid(False)
    ax.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_95.pdf", bbox_inches="tight")
