
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for the Political domain
data = {
    "Approval Rating": np.random.rand(6, 6) * 10 + 60,
    "Disapproval Rating": np.random.rand(6, 6) * 20 + 30,
    "Neutral Rating": np.random.rand(6, 6) * 10 + 50,
    "Uncertain Votes": np.random.rand(6, 6) * 5 + 5,
}

labels = [
    "Candidate A",
    "Candidate B",
    "Candidate C",
    "Candidate D",
    "Candidate E",
    "Candidate F",
]

# Color Scheme (political theme)
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axes = plt.subplots(2, 2, figsize=(10, 10), constrained_layout=True)

for i, (ax, (metric, values)) in enumerate(zip(axes.flatten(), data.items())):
    bplot = ax.boxplot(
        values,
        vert=True,
        patch_artist=True,
        showcaps=False,
        showfliers=False,
        whiskerprops=dict(color="#6d6d6d", linestyle="--", linewidth=1),
        medianprops={"color": "#1f77b4"},
        boxprops=dict(linestyle="-", linewidth=1),
    )
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)
    ax.set_title(metric, fontsize=14, fontweight='bold')
    if i == 2 or i == 3:
        ax.set_xticklabels(labels, rotation=45, ha='right')
    else:
        ax.set_xticks([])
    ax.yaxis.grid(True, linestyle='--', alpha=0.7)
    ax.xaxis.grid(False)
    ax.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_96.pdf", bbox_inches="tight")
