
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New dataset simulating movie ratings across different genres
data = {
    "Mean Rating": np.random.rand(6, 6) * 4 + 1,
    "Median Rating": np.random.rand(6, 6) * 4 + 1,
    "Rating IQR": np.random.rand(6, 6) * 2 + 1,
    "Rating Variance": np.random.rand(6, 6) * 2 + 0.5,
}
genres = [
    "Action",
    "Comedy",
    "Drama",
    "Horror",
    "Romance",
    "Sci-Fi",
]  # Movie genres

# Chart labels and title
xlabel = "Movie Genres"
ylabel = "Ratings"
supertitle = "Analysis of Movie Ratings by Genre"
title = ["Mean Rating", "Median Rating", "Rating IQR", "Rating Variance"]
legendlabels = genres  # Use genres as legend labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
new_colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]

fig, axes = plt.subplots(2, 2, figsize=(10, 10), constrained_layout=True)
fig.suptitle(supertitle, fontsize=16)

for i, (ax, (metric, values)) in enumerate(zip(axes.flatten(), data.items())):
    bplot = ax.boxplot(
        values,
        vert=True,
        patch_artist=True,
        showcaps=False,
        showfliers=False,
        whiskerprops=dict(color="#4f4f4f", linestyle="--", linewidth=1),
        medianprops={"color": "#2f4f4f", "linewidth": 2},
        boxprops=dict(linestyle="--", linewidth=1),
    )
    for patch, color in zip(bplot["boxes"], new_colors):
        patch.set_facecolor(color)
    ax.set_title(title[i])
    ax.set_ylabel(ylabel)
    if i in [2, 3]:
        ax.set_xticklabels(genres, rotation=45)
    else:
        ax.set_xticks([])
    ax.yaxis.grid(True, linestyle='--', which='major', color='grey', alpha=0.7)
    ax.xaxis.grid(False)
    ax.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("box_97.pdf", bbox_inches="tight")
