
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Create a grid of x and y values (representing coordinates)
x = np.linspace(0, 100, 200)
y = np.linspace(0, 100, 200)
X, Y = np.meshgrid(x, y)

# Define a function for temperature distribution
def temperature_distribution(X, Y):
    return (
        20 + 10 * np.sin(X / 10) * np.cos(Y / 20)
        + 5 * np.exp(-((X - 50) ** 2 + (Y - 50) ** 2) / 100)
    )

# Calculate temperature values on the grid
Temperature = temperature_distribution(X, Y)
xlabel = "Longitude"
ylabel = "Latitude"
title = "Temperature Distribution over a Geographical Grid"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Use a colormap suitable for temperature (e.g., 'coolwarm')
n_colors = 15
temperature_cmap = plt.cm.get_cmap("coolwarm", n_colors)

contour = plt.contourf(X, Y, Temperature, levels=n_colors, cmap=temperature_cmap)

# Add a color bar with custom ticks
cbar = plt.colorbar(
    contour, ticks=np.linspace(Temperature.min(), Temperature.max(), n_colors)
)
cbar.ax.set_ylabel('Temperature (°C)')

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Save the plot
plt.savefig("contour_24.pdf", bbox_inches="tight")

# Show the plot
