
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Create a grid of x and z values
x = np.linspace(0, 1, 100)
z = np.linspace(0, 1, 100)
X, Z = np.meshgrid(x, z)

# Adjust the lambda function to reflect different philosophical regions
def lambda_function(X, Z):
    return (
        np.exp(-((X - 0.3) ** 2 + (Z - 0.6) ** 2) / 0.02)  # Philosophical Idealism
        + np.exp(-((X - 0.6) ** 2 + (Z - 0.3) ** 2) / 0.03)  # Empiricism
        + np.exp(-((X - 0.8) ** 2 + (Z - 0.8) ** 2) / 0.04)  # Rationalism
    )

# Calculate the function values on the grid
Z_values = lambda_function(X, Z)
xlabel = "Philosophical Position x"
ylabel = "Philosophical Position y"
title = "Philosophical Landscape"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(8, 6))

# Using a custom color map to reflect the philosophical theme
n_colors = 10  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("Blues", n_colors)

contour = plt.contourf(X, Z, Z_values, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(
    contour, ticks=np.linspace(Z_values.min(), Z_values.max(), n_colors)
)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Save the plot with the specified file name
plt.savefig("contour_26.pdf", bbox_inches="tight")

# Show the plot
