
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
x = np.linspace(-5, 10, 100)
y = np.linspace(-5, 10, 100)
X, Y = np.meshgrid(x, y)
Z = np.sqrt(X**2 + Y**2)

# Labels and Titles
xlabel = 'X Coordinate (m)'
ylabel = 'Y Coordinate (m)'
title = 'Energy Intensity Distribution'
legendlabels = ['Energy Levels']

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Contour
fig, ax = plt.subplots(figsize=(8, 8))
cnt = ax.contour(X, Y, Z, cmap="inferno", linewidths=1.5, linestyles='dashed')
ax.clabel(cnt, cnt.levels, inline=True, fontsize=10)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_31.pdf", bbox_inches="tight")
