
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data generation for traffic density
x = np.linspace(-5, 5, 100)
y = np.linspace(-5, 5, 100)
X, Y = np.meshgrid(x, y)
Z = np.exp(-((X - 1)**2 + (Y - 1)**2)) + np.exp(-((X + 1)**2 + (Y + 1)**2)) - 0.5 * np.exp(-(X**2 + Y**2))

# Chart labels and titles
xlabel = 'X-axis (longitude)'
ylabel = 'Y-axis (latitude)'
title = 'Traffic Density Across City Grid'
suptitle = 'Traffic Density Representation'
legend_labels = ['High Density', 'Medium Density', 'Low Density']

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Contour
fig, ax = plt.subplots(figsize=(8, 8))
cnt = ax.contour(X, Y, Z, levels=10, cmap='Blues', linestyles='dashed')
ax.clabel(cnt, cnt.levels, inline=True, fontsize=10, fmt='%1.1f')

# Adding color bar
cbar = plt.colorbar(cnt)
cbar.ax.set_ylabel('Traffic Density')

# Axis labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("contour_32.pdf", bbox_inches="tight")
