
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
latitude, longitude = np.meshgrid(np.linspace(-90, 90, 100), np.linspace(-180, 180, 100))
temperature = 20 + np.sin(np.radians(latitude)) * np.cos(np.radians(longitude)) * 40  # Simulated temperature distribution

# Text Labels and Chart Metadata
xlabel = "Longitude (°)"
ylabel = "Latitude (°)"
title = "Geographical Temperature Distribution"
suptitle = "Temperature Variation Across Latitude and Longitude"
legendlabels = "Temperature (°C)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Filled contour with labels
fig, ax = plt.subplots(figsize=(8, 8))
contour_lines = ax.contour(latitude, longitude, temperature, colors="black", linewidths=0.5, linestyles='--')
ax.clabel(contour_lines, contour_lines.levels, inline=True, fontsize=10)
heatmap = ax.contourf(latitude, longitude, temperature, cmap="coolwarm")

# Adding labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
fig.suptitle(suptitle)

# Adding a color bar to indicate temperature scale
cbar = fig.colorbar(heatmap, ax=ax, orientation='horizontal', pad=0.1)
cbar.set_label(legendlabels)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_34.pdf", bbox_inches="tight")
