
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generating new sample data for agricultural context
x = np.linspace(-100, 100, 400)
y = np.linspace(-100, 100, 400)
X, Y = np.meshgrid(x, y)
pos = np.dstack((X, Y))

# Influence areas modeled using bivariate Gaussian functions
Z1 = np.exp(-0.01 * ((X - 20) ** 2 + (Y - 20) ** 2)) # Area with high nitrogen levels
Z2 = np.exp(-0.01 * ((X + 20) ** 2 + (Y + 20) ** 2)) # Area with high phosphorus levels

# Titles and labels
title = "Nutrient Levels in Agricultural Fields"
labels = ["High Nitrogen", "High Phosphorus"]
xlabel = "Longitude"
ylabel = "Latitude"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper right"
plt.figure(figsize=(10, 6))

# Plot high nitrogen level area
contour1 = plt.contourf(
    X, Y, Z1, cmap="Greens", alpha=0.6
)  # Use a green color palette

# Plot high phosphorus level area
contour2 = plt.contourf(
    X, Y, Z2, cmap="Blues", alpha=0.6
)  # Use a blue color palette

# Set plot title and legend
plt.title(title, fontsize=16)

# Create legend with color patches
legend_patches = [
    Patch(color="green", label=labels[0], alpha=0.6),
    Patch(color="blue", label=labels[1], alpha=0.6),
]
plt.legend(handles=legend_patches, fontsize=12, loc=legend_location)

# Set equal aspect ratio for the plot
plt.gca().set_aspect("equal", adjustable="box")

# Axis labels
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Reduce whitespace around the plot
plt.savefig("contour_43.pdf", bbox_inches="tight")
