
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Generating sample data for environmental science
x = np.linspace(-100, 100, 400)
y = np.linspace(-100, 100, 400)
X, Y = np.meshgrid(x, y)
pos = np.dstack((X, Y))

# Environmental data modeled using bivariate Gaussian functions
pollution = np.exp(-0.01 * ((X - 20) ** 2 + (Y - 20) ** 2))
temperature = np.exp(-0.01 * ((X + 40) ** 2 + (Y - 40) ** 2))

# Titles and labels
title = "Environmental Impact Zones"
labels = ["Pollution Levels", "Temperature Variations"]
xlabel = "Longitude"
ylabel = "Latitude"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper right"
plt.figure(figsize=(10, 6))

# Plot Pollution levels
contour1 = plt.contourf(
    X, Y, pollution, cmap="Greens", alpha=0.6
)  

# Plot Temperature variations
contour2 = plt.contourf(
    X, Y, temperature, cmap="Blues", alpha=0.6
)  

# Set plot title and legend
plt.title(title, fontsize=16)

# Create legend with color patches
legend_patches = [
    Patch(color="green", label=labels[0], alpha=0.6),
    Patch(color="blue", label=labels[1], alpha=0.6),
]
plt.legend(handles=legend_patches, fontsize=12, loc=legend_location)

# Set equal aspect ratio for the plot
plt.gca().set_aspect("equal", adjustable="box")

# Axis labels
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Reduce whitespace around the plot
plt.savefig("contour_44.pdf", bbox_inches="tight")
