
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Create a grid of x and y values
x = np.linspace(-1, 1, 200)
y = np.linspace(-1, 1, 200)
X, Y = np.meshgrid(x, y)

# Adjust the lambda function to reflect population density in a city
def population_density_function(X, Y):
    return (
        np.exp(-((X - 0.5) ** 2 + (Y - 0.5) ** 2) / 0.01) * 0.9
        + np.exp(-((X + 0.5) ** 2 + (Y - 0.5) ** 2) / 0.02) * 0.7
        + np.exp(-((X) ** 2 + (Y + 0.5) ** 2) / 0.015) * 0.5
    )

# Calculate the function values on the grid
Z = population_density_function(X, Y)
xlabel = "X Coordinate"
ylabel = "Y Coordinate"
title = "Population Density Distribution"
colorbar_label = "Population Density Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a custom colormap
n_colors = 10  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("viridis", n_colors)

contour = plt.contourf(X, Y, Z, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(contour, ticks=np.linspace(Z.min(), Z.max(), n_colors))
cbar.set_label(colorbar_label)

# Label the axes
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)

# Style adjustments
plt.grid(True, linestyle="--", alpha=0.7)  # Add a grid for better readability
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_49.pdf", bbox_inches="tight")
