
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a grid of x (temperature) and z (AQI) values
np.random.seed(1)  # Different seed for different data
x = np.linspace(0, 2, 120)
z = np.linspace(0, 2, 120)
X, Z = np.meshgrid(x, z)

# Define the air quality function with different peaks
def air_quality_function(X, Z):
    return (
        np.exp(-((X - 0.3) ** 2 + (Z - 0.4) ** 2) / 0.02)
        + np.exp(-((X - 1.0) ** 2 + (Z - 1.2) ** 2) / 0.05)
        + np.exp(-((X - 1.7) ** 2 + (Z - 0.8) ** 2) / 0.04)
    )

# Calculate the function values on the grid
Z_values = air_quality_function(X, Z)

# Label parameters
xlabel = "Temperature (normalized)"
ylabel = "Air Quality Index (normalized)"
title = "Air Quality Distribution with Temperature"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a color scheme that represents air quality (green to red)
n_colors = 12  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("RdYlGn_r", n_colors)

contour = plt.contourf(X, Z, Z_values, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(
    contour, ticks=np.linspace(Z_values.min(), Z_values.max(), n_colors)
)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_52.pdf", bbox_inches="tight")
