
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Create a new set of grid for different variables
x = np.linspace(0, 5, 100)
y = np.linspace(0, 5, 100)
X, Y = np.meshgrid(x, y)

# Define a new function with unique pattern
def philosophical_waves(X, Y):
    return np.sin(X) * np.sin(Y) + 0.4 * np.cos(3 * X) * np.sin(2 * Y)

# Calculate values on the grid
Z_values = philosophical_waves(X, Y)
xlabel = "X Axis (Idea Flow)"
ylabel = "Y Axis (Thought Depth)"
title = "Philosophical Waves Pattern"
cbar_label = "Intensity of Reflection"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a distinct colormap with "viridis"
n_levels = 20  # Number of contour levels
cmap = plt.cm.viridis

contour = plt.contourf(X, Y, Z_values, levels=n_levels, cmap=cmap)
plt.contour(X, Y, Z_values, levels=n_levels, colors="k", linewidths=0.5, linestyles='dashed')

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(cbar_label)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_55.pdf", bbox_inches="tight")
