
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Create a new set of grid for athlete performance over time
days = np.linspace(0, 100, 100)
athletes = np.linspace(0, 10, 100)
Days, Athletes = np.meshgrid(days, athletes)

# Define a new function to simulate performance scores
def performance_score(Days, Athletes):
    return np.sin(Days/10) * np.cos(Athletes) + 0.5 * np.sin(Days/5) * np.cos(2 * Athletes)

# Calculate performance scores on the grid
Performance = performance_score(Days, Athletes)
xlabel = "Days"
ylabel = "Athletes"
title = "Athletes' Performance Over Time"
cbar_label = "Performance Score"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a distinct colormap with "viridis"
n_levels = 20
cmap = plt.cm.viridis

contour = plt.contourf(Days, Athletes, Performance, levels=n_levels, cmap=cmap)
plt.contour(Days, Athletes, Performance, levels=n_levels, colors="white", linewidths=0.5)

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(cbar_label)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_56.pdf", bbox_inches="tight")
