
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Literature Popularity data over a year
x = np.linspace(0, 365, 100)  # days of the year
y = np.linspace(0, 100, 100)  # popularity index
X, Y = np.meshgrid(x, y)
Z1 = 40 + 15 * np.exp(-((X - 100) ** 2 + (Y - 50) ** 2) / 3000)  # Fiction
Z2 = 45 + 20 * np.exp(-((X - 250) ** 2 + (Y - 50) ** 2) / 3000)  # Non-Fiction
labels = ["Fiction", "Non-Fiction"]
xlabel = "Days of the Year"
ylabel = "Popularity Index"
title = "Literature Popularity Trends Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 6))

# Contour lines for Fiction (green) and Non-Fiction (purple)
CS1 = ax.contour(
    X, Y, Z1, colors="green", linestyles="solid", linewidths=1.5, label=labels[0]
)
CS2 = ax.contour(
    X, Y, Z2, colors="purple", linestyles="dashed", linewidths=1.5, label=labels[1]
)

# Labels for x and y axes and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, loc='upper right')

# Set the aspect of the plot for better readability
ax.set_aspect("auto")
ax.grid(True, linestyle='--', alpha=0.7)
ax.set_facecolor("#f7f7f7")
ax.set_ylim(0, 100)
ax.set_xlim(0, 365)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_62.pdf", bbox_inches="tight")
