
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Sample data to create philosophical idea distribution contour lines
x = np.linspace(-15, 15, 150)
y = np.linspace(-15, 30, 150)
X, Y = np.meshgrid(x, y)
Z1 = np.exp(-((X - 5) ** 2 + (Y - 6) ** 2) / 8)
Z2 = np.exp(-((X + 6) ** 2 + (Y + 7) ** 2) / 8)

# Labels and texts
labels = ["Idea 1", "Idea 2"]
xlabel = "Thought Space X"
ylabel = "Thought Space Y"
title = "Interaction of Philosophical Ideas"
colorbar_label = "Intensity of Thought"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_fontsize = 13
xlabel_fontsize = 15
ylabel_fontsize = 15
title_fontsize = 18
colorbar_fontsize = 14

# Create the plot
fig, ax = plt.subplots(figsize=(12, 9))

# Contour lines for Idea 1 (purple) and Idea 2 (blue)
CS1 = ax.contour(X, Y, Z1, colors="purple", linestyles="dotted", linewidths=2)
CS2 = ax.contour(X, Y, Z2, colors="blue", linestyles="dashdot", linewidths=2)

# Labels for x and y axes
ax.set_xlabel(xlabel, fontsize=xlabel_fontsize)
ax.set_ylabel(ylabel, fontsize=ylabel_fontsize)
ax.set_title(title, fontsize=title_fontsize)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, fontsize=legend_fontsize)

# Set the aspect of the plot
ax.set_aspect("equal")
ax.grid(True)
ax.set_facecolor("#f0f0f0")
ax.set_ylim(-15, 15)
ax.set_xlim(-15, 15)

# Add color bar to represent intensity of thought
intensity_of_thought = ax.contourf(X, Y, Z1 + Z2, alpha=0.5, cmap="plasma")
cbar = fig.colorbar(intensity_of_thought, ax=ax)
cbar.set_label(colorbar_label, fontsize=colorbar_fontsize)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_67.pdf", bbox_inches="tight")
