
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)
X, Y = np.meshgrid(np.linspace(-10, 10, 300), np.linspace(-10, 10, 300))

# Simulate tourist density with multiple hotspots
Z1 = np.exp(-((X + 3)**2 + (Y + 3)**2) / 10)  # First hotspot
Z2 = np.exp(-((X - 4)**2 + (Y - 4)**2) / 8)   # Second hotspot
Z3 = np.exp(-((X + 5)**2 + (Y - 6)**2) / 12)  # Third hotspot
Z = Z1 + Z2 + Z3

# Extracted strings
supertitle_text = "Tourist Density Distribution in a Region"
title_text = "Tourism Hotspots"
xlabel_text = "Longitude"
ylabel_text = "Latitude"
colorbar_label_text = "Density of Tourists"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Filled contour with custom colormap
fig, ax = plt.subplots(figsize=(10, 8))
cnt = ax.contour(X, Y, Z, levels=15, colors="black", linewidths=0.8, linestyles="--")
ax.clabel(cnt, cnt.levels, inline=True, fontsize=8, fmt="%.2f")
contour_filled = ax.contourf(X, Y, Z, levels=15, cmap="YlGnBu")

# Super Title and Labels
fig.suptitle(supertitle_text, fontsize=14, fontweight='bold')
ax.set_title(title_text)
ax.set_xlabel(xlabel_text)
ax.set_ylabel(ylabel_text)
cbar = fig.colorbar(contour_filled, ax=ax)
cbar.set_label(colorbar_label_text)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("contour_73.pdf", bbox_inches="tight")
