
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data: Simulate the popularity trends of different music genres
np.random.seed(10)
X, Y = np.meshgrid(np.linspace(2000, 2020, 400), np.linspace(0, 100, 400))

# Simulate popularity trends for different genres
Z1 = np.exp(-(((X - 2005) ** 2) / 10 + ((Y - 80) ** 2) / 150))
Z2 = np.exp(-(((X - 2010) ** 2) / 20 + ((Y - 70) ** 2) / 100))
Z3 = np.exp(-(((X - 2015) ** 2) / 25 + ((Y - 60) ** 2) / 80))
Z4 = np.exp(-(((X - 2020) ** 2) / 30 + ((Y - 90) ** 2) / 140))
Z = Z1 + Z2 + Z3 + Z4

# Extracted variables
title_text = "Genre Popularity Trends"
xlabel_text = "Year"
ylabel_text = "Popularity Index"
colorbar_label_text = "Popularity Value"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
contour_levels = 15
linewidths = 1.0
fontsize = 10
fmt = "%.2f"
figsize = (12, 10)
cmap = "viridis"  # New colormap

# Filled contour with labels
fig, ax = plt.subplots(figsize=figsize)
cnt = ax.contour(X, Y, Z, levels=contour_levels, colors="black", linewidths=linewidths, linestyles='dashed')
ax.clabel(cnt, cnt.levels, inline=True, fontsize=fontsize, fmt=fmt)
contour_filled = ax.contourf(X, Y, Z, levels=contour_levels, cmap=cmap)

# Title and Labels
ax.set_title(title_text, fontsize=15, fontweight='bold')
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
cbar = fig.colorbar(contour_filled, ax=ax)
cbar.set_label(colorbar_label_text, fontsize=12)

# Additional Style Adjustments - Grid, legend
ax.grid(color='gray', linestyle='--', linewidth=0.5)
legend_labels = ['Pop', 'Rock', 'Jazz', 'Hip-Hop']
ax.legend(legend_labels, loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_75.pdf", bbox_inches="tight")

