
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data to create contour lines for climate change analysis
x = np.linspace(2000, 2020, 150)
y = np.linspace(350, 420, 150)
X, Y = np.meshgrid(x, y)
Z1 = np.exp(-((X - 2005) ** 2 + (Y - 370) ** 2) / 75)
Z2 = np.exp(-((X - 2015) ** 2 + (Y - 400) ** 2) / 50)

# Labels and texts
labels = ["Region X", "Region Y"]
xlabel = "Year"
ylabel = "CO2 Levels (ppm)"
title = "Climate Change Analysis: Temperature Anomalies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_loc = "upper left"
legend_fontsize = 10
xlabel_fontsize = 12
ylabel_fontsize = 12
title_fontsize = 16
fontweight = "bold"

# Create the plot
fig, ax = plt.subplots(figsize=(12, 10))

# Contour lines for Region X (teal) and Region Y (orange)
CS1 = ax.contour(
    X, Y, Z1, colors="teal", linestyles="-", linewidths=1.5, label=labels[0]
)
CS2 = ax.contour(
    X, Y, Z2, colors="orange", linestyles="--", linewidths=1.5, label=labels[1]
)

# Labels for x and y axes
plt.xlabel(xlabel, fontsize=xlabel_fontsize, fontweight=fontweight)
plt.ylabel(ylabel, fontsize=ylabel_fontsize, fontweight=fontweight)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, loc=legend_loc, fontsize=legend_fontsize)

# Set the aspect of the plot to match the original image
ax.set_aspect("auto")
ax.grid(True, linestyle=':', linewidth='0.5', color='gray')
ax.set_facecolor("#f5f5f5")  # Very light gray background
ax.set_xlim(2000, 2020)
ax.set_ylim(350, 420)

# Title of the plot
plt.title(title, fontsize=title_fontsize, fontweight=fontweight)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_80.pdf", bbox_inches="tight")
