
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate data for the plot
x = np.linspace(0, 20, 1000)
scenarios = np.linspace(1, 9, 9)
y = [
    np.random.uniform(0.8, 1.4)
    * np.exp(-0.05 * (x - i) ** 2 / np.linspace(1, 0.2, 9)[index])
    for index, i in enumerate(np.linspace(5, 15, 9))
]

xlabel = "Time (minutes)"
ylabel = "Stress Level"
title = "Stress Level Across Different Scenarios Over Time"
cbar_label = "Scenario"
legend_labels = [f"Scenario {i+1}" for i in range(9)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 6))

# Create a colorbar
sm = plt.cm.ScalarMappable(cmap="viridis", norm=plt.Normalize(vmin=1, vmax=9))
cbar = plt.colorbar(sm, ax=ax, label=cbar_label)
cbar.set_label(cbar_label, rotation=270, labelpad=20)

# Plotting data
for i in range(9):
    plt.fill_between(x, y[i], color=plt.cm.viridis(i / 9), alpha=0.8, label=legend_labels[i])

plt.ylim(0, 2)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["bottom"].set_visible(True)
ax.spines["left"].set_visible(False)
ax.set_yticks([])

# Add legend
plt.legend(loc='upper right', bbox_to_anchor=(1.15, 1))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_23.pdf", bbox_inches="tight")

