
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt  # Importing the plotting library

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Create some new data for a science domain
y = np.linspace(0, 20, 100)
biological_signal = np.exp(-0.1 * (y - 10) ** 2)
noise = 0.5 * np.exp(-0.2 * (y - 15) ** 2)

# Label parameters
xlabel = 'Measurement Point'
ylabel = 'Amplitude'
title = 'Biological Signal and Noise'
legend_labels = ['Biological Signal', 'Noise']

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for better visibility

# Plot the data with optimized color scheme and style
ax.fill_between(biological_signal, y, color="skyblue", edgecolor="#4682b4", alpha=0.7, label=legend_labels[0])
ax.fill_between(noise, y, color="lightgreen", edgecolor="#32cd32", alpha=0.5, label=legend_labels[1])

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=False, labelbottom=False)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_ylim(0, 20)

# Add a legend
ax.legend(loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_24.pdf", bbox_inches="tight")
