
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

from scipy.stats import gaussian_kde

# Generate a bimodal distribution for movie ratings
ratings_critically_acclaimed = np.random.normal(loc=4.5, scale=0.5, size=500)
ratings_blockbusters = np.random.normal(loc=3.0, scale=0.7, size=500)
movie_ratings = np.concatenate([ratings_critically_acclaimed, ratings_blockbusters])
xs = np.linspace(0, 5, 200)

# Axes Limits and Labels
xticks_values = [0, 1, 2, 3, 4, 5]
xticklabels = ["0", "1", "2", "3", "4", "5"]
yticks_values = [0, 0.1, 0.2, 0.3, 0.4]
yticklabels = ["0.0", "0.1", "0.2", "0.3", "0.4"]
xlim_values = [0, 5]
ylim_values = [0, 0.35]
title = "KDE Plot of Movie Ratings Distribution"
xlabel_value = "Movie Ratings"
ylabel_value = "Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to be more prominent
fig, ax = plt.subplots(figsize=(10, 6))

# Create the KDE plot with adjusted x-axis range
density = gaussian_kde(movie_ratings)
density.covariance_factor = lambda: 0.5
density._compute_covariance()
plt.fill_between(xs, density(xs), color="#6a0dad", edgecolor="#ffd700", linewidth=2, alpha=0.7)

# Set grid lines for clarity
plt.grid(True, linestyle='--', alpha=0.6)

ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)

ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)

plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Set the title and labels
plt.title(title, fontsize=16, fontweight='bold')
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_27.pdf", bbox_inches="tight")
