
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
from scipy.stats import gaussian_kde

# Generate a bimodal distribution representing communication states
data_active = np.random.normal(loc=0.5, scale=0.1, size=500)
data_passive = np.random.normal(loc=-0.5, scale=0.1, size=500)
data = np.concatenate([data_active, data_passive])
xs = np.linspace(-1, 1, 200)

# Axes Limits and Labels
xticks_values = [-1, -0.5, 0, 0.5, 1]
xticklabels = ["-1.0", "-0.5", "0.0", "0.5", "1.0"]
yticks_values = [0, 0.5, 1.0, 1.5, 2.0]
yticklabels = ["0.0", "0.5", "1.0", "1.5", "2.0"]
xlim_values = [-1, 1]
ylim_values = [0, 2.0]
title = "KDE Plot of Communication States Distribution"
xlabel_value = "Communication State"
ylabel_value = "Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(9, 5))

# Create the KDE plot with adjusted x-axis range
density = gaussian_kde(data)
density.covariance_factor = lambda: 0.3
density._compute_covariance()
plt.fill_between(xs, density(xs), color="#a6cee3", edgecolor="#1f78b4", linewidth=2)

ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)

ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)

plt.xlim(xlim_values)
plt.ylim(ylim_values)
# Set the title and labels
plt.title(title)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_28.pdf", bbox_inches="tight")
