
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Sample data: Art Auction Prices
data1 = np.random.normal(loc=1500000, scale=300000, size=1000)  # Impressionism
data2 = np.random.normal(loc=800000, scale=200000, size=1000)   # Modern Art

# Compute density for each dataset
density1 = gaussian_kde(data1)
density2 = gaussian_kde(data2)
xs = np.linspace(500000, 2000000, 300)
ys1 = density1(xs)
ys2 = density2(xs)

# Labels and titles
labels = ["Impressionism", "Modern Art"]
xlabel = "Price ($)"
ylabel = "Density"
chart_title = "Density of Art Auction Prices"
output_file = "density_5_3.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Fill between x for density regions
ax.fill_between(xs, ys1, color="#FFB6C1", alpha=0.6, label=labels[0])  # LightPink
ax.fill_between(xs, ys2, color="#87CEEB", alpha=0.6, label=labels[1])  # SkyBlue

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(chart_title)
ax.set_xlim([500000, 2000000])

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Add legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_33.pdf", bbox_inches="tight")
